#include "testmodel.h"

TestModel::TestModel()
{
    _data << "a" << "b" << "c" << "d" << "e" << "f" << "g";
}

TestModel::TestModel(const TestModel &testModel)
{
    _data = QStringList(testModel._data);
}

TestModel::~TestModel()
{

}

int TestModel::rowCount(const QModelIndex &parent) const
{
    return _data.length();
}

QHash<int, QByteArray> TestModel::roleNames() const
{
    QHash<int, QByteArray> roleNames;
    roleNames.insert(Qt::UserRole + 1, QByteArray("test"));
    return roleNames;
}

QVariant TestModel::data(const QModelIndex &index, int role) const
{
    if (index.row() < 0 || index.row() >= _data.length()) {
        return QVariant();
    }
    if (role != Qt::UserRole + 1) {
        return QVariant();
    }
    return _data.at(index.row());
}
